<?php

class Patients_RequestsController extends Zend_Controller_Action
{

    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$this->view->userislogged = $this->_helper->AccessControlTower->checkAccess();
		$this->view->defaultInfo = $this->_helper->LoadDefaultInfo->getAllInfo($this->view->userislogged[0][0]);
		$this->request = $this->getRequest();
		$this->caseSession = new Zend_Session_Namespace('new_case_request');

		if (isset($this->caseSession->caseObjects['selectedPlan']) and isset($this->view->defaultInfo['allBasket'][0]['Ref #']))
		{
			$detailsPlan = $this->getPaymentPlan($this->caseSession->caseObjects['selectedPlan']);
			$this->view->selected_plan = $detailsPlan['namea'];
			$this->view->cost_plan = $detailsPlan['plana'];
			$this->view->total_cost_plan = $detailsPlan['plana'];
			$this->view->specialisation_job = $this->view->defaultInfo['allBasket'][0]['Categorie Name'];
			$this->view->reference_job = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->view->other_charges = 0;
			if ($this->view->defaultInfo['allBasket'][0]['optionAttachment'] == 'mailing')
			{
				$this->view->total_cost_plan = $detailsPlan['plana'] + 25;
				$this->view->other_charges = 25;
			}
		}	
    }

    public function indexAction()
    {
    	return $this->_redirect('patients/requests/new');	
    }

	private function cleanCacheCase()
	{
		$caseObj = new Common_Model_Sogcases();

		if (isset($this->view->defaultInfo['allBasket'][0]['Ref #']))
		{
			$caseObj->deleteBasketCaseByRef2($this->view->defaultInfo['allBasket'][0]['Ref #']);	
		}	
		unset($this->caseSession->tokenNewCase);
	} 


    public function newAction()
    {

    	/*
		$rosSession = new Zend_Session_Namespace('case_request_ros');
					$keyConer = sha1($caseToken);
					$rosSession->link[$keyConer] = $caseToken;
					$this->view->keyCase = $keyConer;
    	*/

		$step = $this->request->getParam('sp', NULL);

		if (is_null($step))
		{
			//$step = $this->request->getParam('sp', NULL);

			return $this->_redirect('patients/requests/new/sp/1');	
		}
		else{
			$reinit = $this->request->getParam('reinit', NULL);
			if (!is_null($reinit))
			{
				//clean cache cases
				$this->cleanCacheCase();
				return $this->_redirect('patients/requests/new/sp/1');	
			}

			$start = $this->request->getParam('start', NULL);
			if (!is_null($start) and $start == 'yes' and !is_int($this->view->defaultInfo['allBasket']))
			{
				$this->view->signalProgress = true;
			}

			


			//

			//echo $step;

			switch ($step) {
				case 1:
					return $this->_forward('step1', null, null);		
					break;
				case 2:
					return $this->_forward('step2', null, null);		
					break;
				case 3:
					return $this->_forward('step3', null, null);		
					break;
				case 4:
					return $this->_forward('step4', null, null);		
					break;
				case 5:
					return $this->_forward('step5', null, null);		
					break;
				
				
				
				default:
					return $this->_redirect('patients/requests/new/sp/1');	
					break;
			}

		}
    }


    public function editreqAction()
    {
    	// verifiy what triggered this procedure. Only edit Action is allowed
		$this->editSession = new Zend_Session_Namespace('edit_case_request');
		if (!isset($this->editSession->caseToEdit))
		{
			return $this->_redirect('patients/portal');
		}
		//$this->editSession->caseToEdit = $this->view->caseReferenceId;

		$step = $this->request->getParam('sp', NULL);
		if (is_null($step))
		{
			return $this->_redirect('patients/requests/new/sp/1');	
		}
		else{
			


			$start = $this->request->getParam('start', NULL);
			if (!is_null($start) and $start == 'yes' and !is_int($this->view->defaultInfo['allBasket']))
			{
				$this->view->signalProgress = true;
			}

			


			//

			//echo $step;

			switch ($step) {
				case 1:
					return $this->_forward('step1', null, null);		
					break;
				case 2:
					return $this->_forward('step2', null, null);		
					break;
				case 3:
					return $this->_forward('step3', null, null);		
					break;
				case 4:
					return $this->_forward('step4', null, null);		
					break;
				case 5:
					return $this->_forward('step5', null, null);		
					break;
				
				
				
				default:
					return $this->_redirect('patients/requests/new/sp/1');	
					break;
			}

		}
    }


	public function editAction()
    {
		$this->view->caseReferenceId = $this->request->getParam('caseRef', 'Missing !!');
		if ($this->view->caseReferenceId == 'Missing !!')
		{
			return $this->_redirect('patients/portal');
		}
		
		$sogRequestsObj = new Common_Model_Sogcases();	
		$this->view->caseDetail = $sogRequestsObj->getRequestById($this->view->caseReferenceId);
		if ($this->view->caseDetail == false)
		{
			return $this->_redirect('patients/portal');
		}

		if ($this->view->caseDetail['isToBeEdited'] != 1)
		{
			return $this->_redirect('patients/portal');
		}

		//$caseObj = new Common_Model_Sogcases();
		//$caseObj->putCaseInBasket($this->view->caseReferenceId);
		$this->editSession = new Zend_Session_Namespace('edit_case_request');
		$this->editSession->caseToEdit = $this->view->caseReferenceId;

		//all good. start edit option
		return $this->_redirect('patients/requests/editreq/sp/1');
    }



    public function step1Action()
    {
		$newCaseFormObj = new Patients_Form_Cases();

		$catgoriesListObj = new Common_Model_Specialities() ;
		$categoriesList = $catgoriesListObj->getAllCategories();
		$newCaseFormObj->categoriesNewCase($categoriesList);
		
		if (!is_int($this->view->defaultInfo['allBasket'])){
			$isNewCase = false;
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			// there shoulb be only one element in the basked. take [0]
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->view->selectedPlanContinue = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
		}
		else {
			$isNewCase = true;
			unset($this->caseSession->tokenNewCase);
		}
		
		if ($this->request->isPost()) 
		{
			if ($newCaseFormObj->isValid($this->request->getPost())) 
			{
				$this->caseSession->caseObjects['selectedPlan'] = $this->request->getPost('sog_pricing_fld');
				$this->caseSession->caseObjects['categorie'] = $this->request->getPost('sog_categories_fld');
				$this->caseSession->caseObjects['description'] = $this->request->getPost('sog_problemdescription_fld');
				
				if ($isNewCase)
				{

					// set up the initial record in the database
					$caseObj = new Common_Model_Sogcases();
					$returnCaseCreated = $caseObj->createNewCase(1,$this->view->userislogged[0][0],new Zend_Db_Expr('NOW()'),$this->request->getPost('sog_pricing_fld'), 1, $this->request->getPost('sog_categories_fld'));

					if ($returnCaseCreated != false)
					{
						$countryCode = (!is_null($this->view->userislogged[1]['Country Code']))?$this->view->userislogged[1]['Country Code']:'USA';
						$lenghtValue = strlen($returnCaseCreated);
						$caseToken = $countryCode.str_repeat('0', 5 - $lenghtValue).$returnCaseCreated;

						$caseObj->updateRefNumber($returnCaseCreated, $caseToken);
						$caseObj->updateDescriptionForCase($caseToken, $this->request->getPost('sog_problemdescription_fld'));
					
					}

					$this->caseSession->tokenNewCase = $caseToken;
				}
				else 
				{
					// check if the selected plan has changed. if yes, update the DB
					$caseObj = new Common_Model_Sogcases();
					$caseObj->updatePlanAndCategorieForCase($caseToken, $this->caseSession->caseObjects['selectedPlan'], $this->caseSession->caseObjects['categorie']);	
					$caseObj->updateDescriptionForCase($caseToken, $this->request->getPost('sog_problemdescription_fld'));
				}
				return $this->_redirect('/patients/requests/new/sp/2');
			}
		}
		else {
			if (!$isNewCase){
				$newCaseFormObj->populate(array('sog_categories_fld' => $this->view->defaultInfo['allBasket'][0]['Categorie'], 'sog_pricing_fld'=>$this->view->defaultInfo['allBasket'][0]['Selected Plan'], 'sog_problemdescription_fld'=>$this->view->defaultInfo['allBasket'][0]['description']));
			}	
		}
		
		$this->view->categoriesForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step1.php');	
	}

	public function step2Action()
    {
    	if (isset($this->caseSession->tokenNewCase))
		{
			$caseToken = $this->caseSession->tokenNewCase;
		}
		elseif (!is_int($this->view->defaultInfo['allBasket']))
		{
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->caseSession->caseObjects['categorie'] = $this->view->defaultInfo['allBasket'][0]['Categorie'];
		}
		else
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('/patients/requests/new/sp/1');
		}

		$newCaseFormObj = new Patients_Form_Cases();
    	$newCaseFormObj->questionsForCase();
    	$this->view->errors_form = false;
		$this->view->errors_notification = '';



		if ($this->request->isPost()) 
		{
			if ($newCaseFormObj->isValid($this->request->getPost())) 
			{
				$this->caseSession->caseObjects['question 1'] = $this->request->getPost('sog_question1_fld');
				$this->caseSession->caseObjects['question 2'] = $this->request->getPost('sog_question2_fld');
				$this->caseSession->caseObjects['question 3'] = $this->request->getPost('sog_question3_fld');
				
				$caseObj = new Common_Model_Sogcases();
				$caseObj->updateQuestionsForCase($caseToken, $this->request->getPost('sog_question1_fld'), $this->request->getPost('sog_question2_fld'), $this->request->getPost('sog_question3_fld'));	
					
				return $this->_redirect('/patients/requests/new/sp/3');
			}
			else
			{

			}

			//return $this->_redirect('/patients/requests/new/sp/3');
		}
		else {
			$newCaseFormObj->populate(array('sog_question1_fld' => $this->view->defaultInfo['allBasket'][0]['question1'], 'sog_question2_fld'=>$this->view->defaultInfo['allBasket'][0]['question2'], 'sog_question3_fld'=>$this->view->defaultInfo['allBasket'][0]['question3']));
				
		}

		$this->view->newCaseForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step2.php');	
    }

    public function step3Action()
    {
    	if (isset($this->caseSession->tokenNewCase))
		{
			$caseToken = $this->caseSession->tokenNewCase;
		}
		elseif (!is_int($this->view->defaultInfo['allBasket']))
		{
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->caseSession->caseObjects['categorie'] = $this->view->defaultInfo['allBasket'][0]['Categorie'];
		}
		else
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('/patients/requests/new/sp/1');
		}
		
		
		$newCaseFormObj = new Patients_Form_Cases();
    	$newCaseFormObj->attachmentsForCase();
    	$this->view->errors_form = false;
		$this->view->errors_notification = '';

		if ($this->request->isPost()) 
		{
			if ($newCaseFormObj->isValid($this->request->getPost())) 
			{
				//echo $this->request->getPost('sog_optionAttachment_fld');
				//die();
				$this->caseSession->caseObjects['option attachment'] = $this->request->getPost('sog_optionAttachment_fld');
				
				$caseObj = new Common_Model_Sogcases();
				$caseObj->updateAttachmentsForCase($caseToken, $this->request->getPost('sog_optionAttachment_fld'));	
					
				return $this->_redirect('/patients/requests/new/sp/4');
			}
			else
			{
				print_r($newCaseFormObj->getErrors());
				die('here');

			}
		}
		else {
			$newCaseFormObj->populate(array('sog_optionAttachment_fld' => $this->view->defaultInfo['allBasket'][0]['optionAttachment']));
		}

		$sogfilesObj = new Common_Model_Sogfiles();
        $this->view->listUploadedFiles = $sogfilesObj->getAttachmentsForCase($caseToken);
		$this->view->newCaseForm = $newCaseFormObj;

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step3.php');	
    }

	public function step4Action()
    {
    	if (isset($this->caseSession->tokenNewCase))
		{
			$caseToken = $this->caseSession->tokenNewCase;
		}
		elseif (!is_int($this->view->defaultInfo['allBasket']))
		{
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->caseSession->caseObjects['categorie'] = $this->view->defaultInfo['allBasket'][0]['Categorie'];
		}
		else
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('/patients/requests/new/sp/1');
		}

		$this->view->description = $this->view->defaultInfo['allBasket'][0]['description'];
		$this->view->question1 = $this->view->defaultInfo['allBasket'][0]['question1'];
		$this->view->question2 = $this->view->defaultInfo['allBasket'][0]['question2'];
		$this->view->question3 = $this->view->defaultInfo['allBasket'][0]['question3'];
		$this->view->attachment = $this->view->defaultInfo['allBasket'][0]['optionAttachment'];

		if ($this->request->isPost()) 
		{



			return $this->_redirect('/patients/requests/new/sp/5');
		}

		$sogfilesObj = new Common_Model_Sogfiles();
        $this->view->listUploadedFiles = $sogfilesObj->getAttachmentsForCase($caseToken);

    	//$this->view->categoriesForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step4.php');	
    }


	public function step5Action()
    {
    	if (isset($this->caseSession->tokenNewCase))
		{
			$caseToken = $this->caseSession->tokenNewCase;
		}
		elseif (!is_int($this->view->defaultInfo['allBasket']))
		{
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->caseSession->caseObjects['categorie'] = $this->view->defaultInfo['allBasket'][0]['Categorie'];
		}
		else
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('/patients/requests/new/sp/1');;
		}
		


		$paymentFormObj = new Patients_Form_Payments();
		$this->view->errors_form = false;
		$paymentFormObj->proceedPayment();
		
		
		if ($this->request->isPost()) 
		{
			if ($paymentFormObj->isValid($this->request->getPost())) 
			{
				$cardNumber=str_replace("+","",$this->request->getPost('sog_cardnumber_fld')); 
				$cardName = $this->request->getPost('sog_cardname_fld');
				$expiryMonth = $this->request->getPost('sog_expirationmonth_fld');
				$expiryYear = $this->request->getPost('sog_expirationyear_fld');
				$cvv = $this->request->getPost('sog_cvvnumber_fld');
				
				$expirationDate = $expiryMonth.'/'.$expiryYear;
				$payment = $this->proceedPayment($this->caseSession->caseObjects['selectedPlan'], $cardNumber, $cardName, $expirationDate, $cvv );
				if ($payment === true)
				{
					$caseObj = new Common_Model_Sogcases();
					$caseObj->updateBasketForCase($caseToken);
					$this->caseSession->caseObjects['paymentDone'] = true;

					$rosSession = new Zend_Session_Namespace('case_request_ros');
					$keyConer = sha1($caseToken);
					$rosSession->link[$keyConer] = $caseToken;
					$this->view->keyCase = $keyConer;

					include_once(CCPATH_APPLICATION.'/data/mails/at_case_created.php');
					
					$mail_obj = new Common_Model_Mail();
					$mail_obj->sendmail($this->view->userislogged[1]['Email'], '','cases@secondopinionglobal.com', 'Your new SOG case have been received.',$message_to_opener,'Your new SOG case have been received.');

					return $this->_forward('step6', null, null);	

					//return $this->_redirect('/patients/requests/new/sp/6');
					//return $this->_redirect('patients/portal');
				}
				else 
				{
					$this->view->errors_form = true;
					$this->view->error_message = '';
					$this->view->notification = 'Error with the payment.'.$payment;
				}
			}
			else 
			{
				$this->view->errors_form = true;
				$this->view->error_message = $paymentFormObj->getMessages();
				$this->view->notification = 'Errors in the form. Please fill or correct the fields highlithed in red.';
			}
		}

		$this->view->paymentForm = $paymentFormObj;

    	//$this->view->categoriesForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step5.php');	
    }

    public function step6Action()
    {
    	

    	$this->cleanCacheCase();

    	//$this->view->categoriesForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step6.php');	
    }

	private function proceedPayment($planSelected , $cardNumber, $cardName, $expirationDate, $cvv ) 
	{
		require 'Braintree/Braintree.php';
		$config = Zend_Controller_Front::getInstance()->getParam('bootstrap');
		$btKeys = $config->getOption('bt');
		
		Braintree_Configuration::environment('sandbox');
		Braintree_Configuration::merchantId($btKeys["merchantid"]);
		Braintree_Configuration::publicKey($btKeys["publickey"]);
		Braintree_Configuration::privateKey($btKeys["privatekey"]);
		
		
		$detailsPlan = $this->getPaymentPlan($planSelected);
		$amount = $detailsPlan['plana']; 



		if (isset($this->caseSession->caseObjects['selectedPlan']) and isset($this->view->defaultInfo['allBasket'][0]['Ref #']))
		{
			
			if ($this->view->defaultInfo['allBasket'][0]['optionAttachment'] == 'mailing')
			{
				$amount+=25;
			}
		}
		
		$sale = array(
				'amount' => $amount,
				'creditCard'   => array(
					'number'  => $cardNumber,
					'cardholderName' => $cardName,
					'expirationDate' => $expirationDate,
					'cvv' => $cvv));
		try 
		{		
			$result = Braintree_Transaction::sale($sale);
			//echo '<pre>'; print_r($result);
			if ($result->success)
			{
				return true;
			}
			else
			{
				return $result->_attributes['message'];
			}
		}
		catch(Exception $e) 
		{
			//echo '<pre>'; print_r($e);
			return 'Error in the transaction. Try again later.';
		}
	}
	
	
	private function getPaymentPlan($selectedPlan)
	{
		$config = Zend_Controller_Front::getInstance()->getParam('bootstrap');
		$btKeys = $config->getOption('bt');

		if ($selectedPlan == 'a'){
			return array('namea' => $btKeys['namea'],'plana' => $btKeys['plana']);
		}
		elseif ($selectedPlan == 'b'){
			return array('namea' => $btKeys['nameb'],'plana' => $btKeys['planb']);
		}
		elseif ($selectedPlan == 'c'){
			return array('namea' => $btKeys['namec'],'plana' => $btKeys['planc']);
		}		
	}

	public function abortAction()
	{
		$caseObj = new Common_Model_Sogcases();

		if (isset($this->view->defaultInfo['allBasket'][0]['Ref #']))
		{
			$caseObj->deleteBasketCaseByRef2($this->view->defaultInfo['allBasket'][0]['Ref #']);	
		}	
		unset($this->caseSession->tokenNewCase);	
		return $this->_redirect('patients/portal');
	}







/*
	public function step4Action()
    {
    	if (isset($this->caseSession->tokenNewCase))
		{
			$caseToken = $this->caseSession->tokenNewCase;
		}
		elseif (!is_int($this->view->defaultInfo['allBasket']))
		{
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->caseSession->caseObjects['categorie'] = $this->view->defaultInfo['allBasket'][0]['Categorie'];
		}
		else
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('patients/newsogs/index');
		}
		
		$detailsPlan = $this->getPaymentPlan($this->caseSession->caseObjects['selectedPlan']);
		$this->view->selected_plan = $detailsPlan['namea'];
		$this->view->cost_plan = $detailsPlan['plana'];
		$this->view->total_cost_plan = $detailsPlan['plana'];
		$this->view->specialisation_job = $this->view->defaultInfo['allBasket'][0]['Categorie Name'];
		$this->view->reference_job = $caseToken;
		$newCaseFormObj = new Patients_Form_Cases();
		$newCaseFormObj->proceedNewCase();
		$this->view->errors_form = false;
		$this->view->errors_notification = '';

    	$ros_obj = new Common_Model_Ros();	
					$questionslist = $ros_obj->getrosCodes();
					$this->view->qros = $questionslist;

    	//$this->view->categoriesForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step4.php');	
    }
	public function step5Action()
    {
    	if (isset($this->caseSession->tokenNewCase))
		{
			$caseToken = $this->caseSession->tokenNewCase;
		}
		elseif (!is_int($this->view->defaultInfo['allBasket']))
		{
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->caseSession->caseObjects['categorie'] = $this->view->defaultInfo['allBasket'][0]['Categorie'];
		}
		else
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('patients/newsogs/index');
		}
		
		$detailsPlan = $this->getPaymentPlan($this->caseSession->caseObjects['selectedPlan']);
		$this->view->selected_plan = $detailsPlan['namea'];
		$this->view->cost_plan = $detailsPlan['plana'];
		$this->view->total_cost_plan = $detailsPlan['plana'];
		$this->view->specialisation_job = $this->view->defaultInfo['allBasket'][0]['Categorie Name'];
		$this->view->reference_job = $caseToken;
		$newCaseFormObj = new Patients_Form_Cases();
		$newCaseFormObj->proceedNewCase();
		$this->view->errors_form = false;
		$this->view->errors_notification = '';

    	$newCaseFormObj = new Patients_Form_Cases();
    	$ros_objs = new Common_Model_HH();	
				$hh1list = $ros_objs->getHHCodes(2);

				if (isset($this->view->defaultInfo['allBasket'][0]['medicFamlInfo']))
				{
					$preloadedData = array_flip(split(',',$this->view->defaultInfo['allBasket'][0]['medicFamlInfo']));	
				}
				else 
				{
					$preloadedData = array();	
				}
				
				$totalqts = sizeof($hh1list['catb']);
				$columns1 = ceil($totalqts/4);
				$counter = 1; $i = 1;
				foreach ($hh1list['catb'] as $cKey => $cValue)
				{
					if ($counter < $columns1)
					{
						if (isset($preloadedData[$cValue['idqx']]))
						{
							$preloadedDataFB[$i][$cValue['idqx']] = $cValue['idqx'];
						}
						$listOfQuestions[$i][$cValue['idqx']] = $cValue['question'];
						$counter++;
					}
					else 
					{
						$counter = 1;	
						$i++;
					}
				}
				
				//echo '<pre>';print_r($listOfQuestions);
				$newCaseFormObj->medicalPastForCase($listOfQuestions);
				
				if ($this->request->isPost()) 
				{
					if (!$newCaseFormObj->isValid($request->getPost())) 
					{
						$this->view->errors_form = true;
						$this->view->errors_notification = 'Error. Your data cannot be submited, please correct the errors highlithed below.';
					}
					else {
						
						$dataToSave = array();
						$col1 = $request->getPost('sog_questionidx_fld_1', NULL);
						if (!is_null($col1))
						{
							$dataToSave = array_merge($dataToSave, $col1);
						}
						
						$col2 = $request->getPost('sog_questionidx_fld_2', NULL);
						if (!is_null($col2))
						{
							$dataToSave = array_merge($dataToSave, $col2);
						}
						
						$col3 = $request->getPost('sog_questionidx_fld_3', NULL);
						if (!is_null($col3))
						{
							$dataToSave = array_merge($dataToSave, $col3);
						}
						
						$col4 = $request->getPost('sog_questionidx_fld_4', NULL);
						if (!is_null($col4))
						{
							$dataToSave = array_merge($dataToSave, $col4);
						}
						
						$caseObj = new Common_Model_Sogcases();
						$caseObj->updateMedicFamilyForCase($caseToken, implode(',', array_values($dataToSave)), $request->getPost('sog_description_fld'));
						echo 'success';
						return;
					}
				}
				else {
					
					if (isset($this->view->defaultInfo['allBasket'][0]))
					{
						if (isset($preloadedDataFB[1]))
						{
							$newCaseFormObj->sog_questionidx_fld_1->setValue($preloadedDataFB[1]);
						}
						if (isset($preloadedDataFB[2]))
						{
							$newCaseFormObj->sog_questionidx_fld_2->setValue($preloadedDataFB[2]);
						}
						if (isset($preloadedDataFB[3]))
						{
							$newCaseFormObj->sog_questionidx_fld_3->setValue($preloadedDataFB[3]);
						}
						if (isset($preloadedDataFB[4]))
						{
							$newCaseFormObj->sog_questionidx_fld_4->setValue($preloadedDataFB[4]);
						}

						$dataToPost = array(
							'sog_description_fld' => $this->view->defaultInfo['allBasket'][0]['descriptionFamlInfo'],
						);
						$newCaseFormObj->populate($dataToPost);
					}
				}
				
				$this->view->questionsForm = $newCaseFormObj;
				$this->view->hh1 = $hh1list['catb'];


    	//$this->view->categoriesForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step5.php');	
    }
	public function step6Action()
    {
    	if (isset($this->caseSession->tokenNewCase))
		{
			$caseToken = $this->caseSession->tokenNewCase;
		}
		elseif (!is_int($this->view->defaultInfo['allBasket']))
		{
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->caseSession->caseObjects['categorie'] = $this->view->defaultInfo['allBasket'][0]['Categorie'];
		}
		else
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('patients/newsogs/index');
		}
		
		$detailsPlan = $this->getPaymentPlan($this->caseSession->caseObjects['selectedPlan']);
		$this->view->selected_plan = $detailsPlan['namea'];
		$this->view->cost_plan = $detailsPlan['plana'];
		$this->view->total_cost_plan = $detailsPlan['plana'];
		$this->view->specialisation_job = $this->view->defaultInfo['allBasket'][0]['Categorie Name'];
		$this->view->reference_job = $caseToken;
		$newCaseFormObj = new Patients_Form_Cases();
		$newCaseFormObj->proceedNewCase();
		$this->view->errors_form = false;
		$this->view->errors_notification = '';

    	//$this->view->categoriesForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step6.php');	
    }*/


	


	/*	
	
	public function loadattchAction()
	{
		if (isset($this->caseSession->tokenNewCase))
		{
			$caseToken = $this->caseSession->tokenNewCase;
		}
		else
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('patients/newsogs/index');
		}		
		
		$request = $this->getRequest();
		$cKey = $request->getParam('ckey', NULL);
		
		if (!isset($this->caseSession->componentsPagesEnc[$cKey])) 
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('patients/newsogs/index');
		}
		
		// Get the plan selected by the patient
		$detailsPlan = $this->getPaymentPlan($this->caseSession->caseObjects['selectedPlan']);
		$this->view->selected_plan = $detailsPlan['namea'];
		$this->view->cost_plan = $detailsPlan['plana'];
		$this->view->total_cost_plan = $detailsPlan['plana'];
		
		
		$this->view->specialisation_job = ($this->view->defaultInfo['allBasket'][0]['Categorie Name']);
		$this->view->reference_job = $caseToken;
		$this->view->keyFiles = $cKey;
		$this->view->selectedPlan = $this->caseSession->caseObjects['selectedPlan'];
		$this->view->errors_form = false;
		$this->view->errors_notification = '';
		
		$newCaseFormObj = new Patients_Form_Cases();
		$newCaseFormObj->uploadfilesForCase();
		
		if ($request->isPost()) 
		{
			if (!$newCaseFormObj->isValid($request->getPost())) 
			{
				$this->view->errors_form = true;
				$this->view->errors_notification .= '<br> Sorry, we cannot save the changes due to the error highligthed in Red below.';
				//print_r($newCaseFormObj->getErrors());
			}
			else
			{
				if (sizeof($newCaseFormObj->sog_docnotes_fld->getFileName()) != 0) 
				{
					$locationFile = $newCaseFormObj->sog_docnotes_fld->getFileName(); 
					$up_fileinfo = pathinfo($locationFile);
					$location = $newCaseFormObj->sog_docnotes_fld->getValue();
					if(!file_exists($up_fileinfo['dirname'].'/'.$caseToken))
					{
						mkdir($up_fileinfo['dirname'].'/'.$caseToken);
					}
					$filename = 'docnotes.'.$up_fileinfo['extension'];
					$new_destination = $up_fileinfo['dirname'].'/'.$caseToken.'/'.$filename;
					$filterRename = new Zend_Filter_File_Rename(array('target' => $new_destination, 'overwrite' => true)); 
					$filterRename->filter($locationFile); 
					$newCaseFormObj->sog_docnotes_fld->receive();
				}
				
				if (sizeof($newCaseFormObj->sog_labreports_fld->getFileName()) != 0) 
				{

				$locationFile = $newCaseFormObj->sog_labreports_fld->getFileName(); 
				$up_fileinfo = pathinfo($locationFile);
				$location = $newCaseFormObj->sog_labreports_fld->getValue();
				if(!file_exists($up_fileinfo['dirname'].'/'.$caseToken))
				{
					mkdir($up_fileinfo['dirname'].'/'.$caseToken);
				}
				$filename = 'labreports.'.$up_fileinfo['extension'];
				$new_destination = $up_fileinfo['dirname'].'/'.$caseToken.'/'.$filename;
				$filterRename = new Zend_Filter_File_Rename(array('target' => $new_destination, 'overwrite' => true)); 
				$filterRename->filter($locationFile); 
				$newCaseFormObj->sog_labreports_fld->receive();
				}
				
				
				if (sizeof($newCaseFormObj->sog_imagesscans_fld->getFileName()) != 0) 
				{
				$locationFile = $newCaseFormObj->sog_imagesscans_fld->getFileName(); 
				$up_fileinfo = pathinfo($locationFile);
				$location = $newCaseFormObj->sog_imagesscans_fld->getValue();
				if(!file_exists($up_fileinfo['dirname'].'/'.$caseToken))
				{
					mkdir($up_fileinfo['dirname'].'/'.$caseToken);
				}
				$filename = 'imgstudy.'.$up_fileinfo['extension'];
				$new_destination = $up_fileinfo['dirname'].'/'.$caseToken.'/'.$filename;
				$filterRename = new Zend_Filter_File_Rename(array('target' => $new_destination, 'overwrite' => true)); 
				$filterRename->filter($locationFile); 
				$newCaseFormObj->sog_imagesscans_fld->receive();
				}
				
				if (sizeof($newCaseFormObj->sog_otherdocuments_fld->getFileName()) != 0) 
				{
				$locationFile = $newCaseFormObj->sog_otherdocuments_fld->getFileName(); 
				$up_fileinfo = pathinfo($locationFile);
				$location = $newCaseFormObj->sog_otherdocuments_fld->getValue();
				if(!file_exists($up_fileinfo['dirname'].'/'.$caseToken))
				{
					mkdir($up_fileinfo['dirname'].'/'.$caseToken);
				}
				$filename = 'otherdoc.'.$up_fileinfo['extension'];
				$new_destination = $up_fileinfo['dirname'].'/'.$caseToken.'/'.$filename;
				$filterRename = new Zend_Filter_File_Rename(array('target' => $new_destination, 'overwrite' => true)); 
				$filterRename->filter($locationFile); 
				$newCaseFormObj->sog_otherdocuments_fld->receive();
				}
				
				
				$this->view->upload_done = true;
				
			}
		}
		
		$this->view->newCaseForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newcases/upload_view.php');	
	}

	public function reviewAction()
    {
		$detail_1 = $this->getPaymentPlan($this->caseSession->caseObjects['selectedPlan']);
		$detail_2 = $this->caseSession->progressNewCase;
		$detail_3 = $this->caseSession->caseObjects;
		
		$this->view->caseInfos = array_merge($detail_1,$detail_2,$detail_3,array('tokenNewCase' => $this->caseSession->tokenNewCase, 'categorieName' => $this->view->defaultInfo['allBasket'][0]['Categorie Name']));
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newcases/review_view.php');	
	}
	
	
	public function paymentAction()
    {
				
		$paymentFormObj = new Patients_Form_Payments();
		$this->view->errors_form = false;
		$paymentFormObj->proceedPayment();
		
		
		if ($this->request->isPost()) 
		{
			if ($paymentFormObj->isValid($this->request->getPost())) 
			{
				$cardNumber=str_replace("+","",$this->request->getPost('sog_cardnumber_fld')); 
				$cardName = $this->request->getPost('sog_cardname_fld');
				$expiryMonth = $this->request->getPost('sog_expirationmonth_fld');
				$expiryYear = $this->request->getPost('sog_expirationyear_fld');
				$cvv = $this->request->getPost('sog_cvvnumber_fld');
				
				$expirationDate = $expiryMonth.'/'.$expiryYear;
				$payment = $this->proceedPayment($this->caseSession->caseObjects['selectedPlan'], $cardNumber, $cardName, $expirationDate, $cvv );
				if ($payment === true)
				{§
					$caseObj = new Common_Model_Sogcases();
					$caseObj->updateBasketForCase($caseToken);
					$this->caseSession->caseObjects['paymentDone'] = true;
					return $this->_redirect('patients/newsogs/confirm');
				}
				else 
				{
					$this->view->errors_form = true;
					$this->view->error_message = '';
					$this->view->notification = 'Error with the payment.'.$payment;
				}
			}
			else 
			{
				$this->view->errors_form = true;
				$this->view->error_message = $paymentFormObj->getMessages();
				$this->view->notification = 'Errors in the form. Please fill or correct the fields highlithed in red.';
			}
		}

		$this->view->paymentForm = $paymentFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newcases/payment_view.php');	
	}*/
	/*

	public function medicalAction()
    {	
		if (!isset($this->caseSession->tokenNewCase)){
			// if token not exists, choice not yet made. return back to choice.
			return $this->_redirect('patients/newsogs/index');
		}
		else {
			$caseToken = $this->caseSession->tokenNewCase;
			$this->caseSession->statusNewCase = 'medical';
		}
		
		if (!$this->caseSession->caseObjects['paymentDone'])
		{
			return $this->_redirect('patients/newsogs/');
		}
	
	
		if ($this->request->isPost()) {
				return $this->_redirect('patients/newsogs/questions');
			
		}
		$ros_objs = new Common_Model_HH();	
			$hh1list = $ros_objs->getHHCodes(1); //print_r($hh1list);
			$this->view->hh1 = $hh1list;
			$hh2list = $ros_objs->getHHCodes(2); //print_r($hh1list);
			$this->view->hh2 = $hh2list;

		$ros_obj = new Common_Model_Ros();	
			$questionslist = $ros_obj->getrosCodes();
			$this->view->qros = $questionslist;
			

			
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newcases/medical_view.php');	
	}

	
	public function questionsAction()
    {	
		if ($this->request->isPost()) {
					return $this->_redirect('patients/newsogs/upload');
		}
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newcases/questions_view.php');	
	}
	
	public function uploadAction()
    {	
		if ($this->request->isPost()) {
					return $this->_redirect('patients/newsogs/confirm');
		}
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newcases/upload_view.php');	
	}
	
	
	public function confirmAction()
    {	
		if (!isset($this->caseSession->tokenNewCase)){
			// if token not exists, choice not yet made. return back to choice.
			return $this->_redirect('patients/newsogs/index');
		}
		else {
			$caseToken = $this->caseSession->tokenNewCase;
		}
		
		if (!$this->caseSession->caseObjects['paymentDone'])
		{
			return $this->_redirect('patients/newsogs/payment');
		}
		else
		{	
			include_once(CCPATH_APPLICATION.'/data/mails/at_case_created.php');
			//add notification
			$notificationObj = new Common_Model_Notifications();
			$notificationObj->addNotificationForUser($topicNotification, $messageNotification, 'system', date("Y-m-d H:i:s"), $this->view->userislogged[0][0], 'message', 0);
					
			Zend_Session::namespaceUnset('new_case_request');
				
		}
			
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newcases/confirm_view.php');	
	}	
	*/
	
	
}